% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateHb.r
\name{calculateHb}
\alias{calculateHb}
\title{Calculate Heterozygote Balance}
\usage{
calculateHb(data, ref, hb = 1, kit = NULL, sex.rm = FALSE,
  qs.rm = FALSE, ignore.case = TRUE, exact = FALSE, word = FALSE,
  debug = FALSE)
}
\arguments{
\item{data}{a data frame containing at least
'Sample.Name', 'Marker', 'Height', and 'Allele'.}

\item{ref}{a data frame containing at least
'Sample.Name', 'Marker', 'Allele'.}

\item{hb}{numerical, definition of heterozygote balance. Default is hb=1. 
hb=1: HMW/LMW, hb=2: LMW/HMW, hb=3; min(Ph)/max(Ph).}

\item{kit}{character defining the kit used. If NULL automatic detection is attempted.}

\item{sex.rm}{logical TRUE removes sex markers defined by 'kit'.}

\item{qs.rm}{logical TRUE removes quality sensors defined by 'kit'.}

\item{ignore.case}{logical indicating if sample matching should ignore case.}

\item{exact}{logical indicating if exact sample matching should be used.}

\item{word}{logical indicating if word boundaries should be added before sample matching.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame with with columns 'Sample.Name', 'Marker', 'Delta', 'Hb', 'MPH'.
}
\description{
Calculates the heterozygote (intra-locus) peak balance.
}
\details{
Calculates the heterozygote (intra-locus) peak balance for a dataset.
Known allele peaks will be extracted using the reference prior to analysis.
Calculates the heterozygote balance (Hb), size difference between
heterozygous alleles (Delta), and mean peak height (MPH).
NB! 'X' and 'Y' will be handled as '1' and '2' respectively.
}
\examples{
data(ref2)
data(set2)
# Calculate average balances.
calculateHb(data=set2, ref=ref2)
}
