\name{plot.survAUC}
\alias{plot.survAUC}
\alias{plot.survErr}
\title{Plot method for survAUC and survErr Objects}
\description{
  Plot a \code{survAUC} object generated by the functions \code{\link{AUC.uno}},
  \code{\link{AUC.sh}}, \code{\link{AUC.cd}}, \code{\link{AUC.hc}} and
  \code{\link{predErr}}.
}
\usage{
\method{plot}{survAUC}(x, col="red", type="l", ylim=c(0,1),
        xlab="Time",ylab="AUC", 
        main="Time-dependent AUC", add=FALSE, \dots)

\method{plot}{survErr}(x, col="red", type="l", ylim=c(0,1),
        xlab="Time",ylab="Prediction error", 
        main="Time-dependent Prediction Error", add=FALSE, \dots)
}
\arguments{
  \item{x}{An object of class \code{survAUC}.}
  \item{col}{The color used to draw the AUC curve.}
  \item{type}{The type of plot to be drawn. See 
	  argument 'type' of the \code{\link{plot}} function.}
  \item{ylim}{The y limits of the plot.}
  \item{xlab}{The title of the x axis. See \code{\link{title}}.}
  \item{ylab}{The title of the y axis. See \code{\link{title}}.}
  \item{main}{The main title of the plot. See \code{\link{title}}.}
  \item{add}{A logical specifying whether the AUC-Curve should be added to an
             already existing plot.}
  \item{\dots}{Graphics parameters that can be passed to 'plot'.}
}

\seealso{
  \code{\link{AUC.sh}}, \code{\link{AUC.cd}}, \code{\link{AUC.hc}}, \code{\link{AUC.uno}}, \code{\link{predErr}}
}
\examples{
TR <- ovarian[1:16,]
TE <- ovarian[17:26,]
train.fit  <- coxph(Surv(futime, fustat) ~ age,
                    x=TRUE, y=TRUE, method="breslow", data=TR)

lp <- predict(train.fit)
lpnew <- predict(train.fit, newdata=TE)
Surv.rsp <- Surv(TR$futime, TR$fustat)
Surv.rsp.new <- Surv(TE$futime, TE$fustat)
times <- seq(10, 600, 10)                  

AUC_sh <- AUC.sh(Surv.rsp, Surv.rsp.new, lp, lpnew, times)
plot(AUC_sh)
abline(h = 0.5)

BrierScore <- predErr(Surv.rsp, Surv.rsp.new, lp, lpnew, times, 
                      type = "brier", int.type = "weighted")
plot(BrierScore)
abline(h = 0.25)

}
\keyword{hplot} \keyword{classif}
