% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_PACKAGES2.R
\name{findNewestPkgInds}
\alias{findNewestPkgInds}
\alias{findNewestPkgRows}
\title{Find newest packages in a package info data.frame}
\usage{
findNewestPkgInds(df, pkgcol = "package", verscol = "version")

findNewestPkgRows(
  df,
  pkgcol = "package",
  verscol = "version",
  newcol = "new",
  verbose = FALSE,
  logfun = message
)
}
\arguments{
\item{df}{data.frame. Table of package information}

\item{pkgcol}{string. Name of column containing package name}

\item{verscol}{string. Name of column containing package version in version-string form.}

\item{newcol}{character. Experimental. column name for the column indicating that the version is new.}

\item{verbose}{logical. Should debugging information be written using \code{logfun} during this process.}

\item{logfun}{function. Logging function (closure) which should be called to write verbose logging messages during the process.}
}
\value{
a data.frame with the same columns as \code{df} which contains
only the most recent row for each unique package name, as determined
by the contents of \code{df[[verscol]]}

for \code{findNewestPkgInds}, the indices of the rows representing
the newest version of each package within \code{df}. For
\code{findNewestPkgRows}, the rows themselves from \code{df} representing
the newest version of each package.
}
\description{
Find newest packages in a package info data.frame
}
