% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_acf.R
\name{block_acf}
\alias{block_acf}
\title{Compute autocorrelation function}
\usage{
block_acf(resids, blocks, max_lag, make_plot = TRUE, ...)
}
\arguments{
\item{resids}{The variable for which the ACF is to be computed (often a vector of residuals from a fitted model)}

\item{blocks}{A categorical variable indicating the groupings (must be the same length as resids. ACF will be computed only for data points within the same block.)}

\item{max_lag}{ACF will be computed at 0-max_lag lags, ignoring all observations that span blocks. Defaults to the minimum number of observations in any block. The function will allow you to specify a max_lag longer than the shortest block if you so choose.}

\item{make_plot}{Logical. Should a plot be produced? Defaults to TRUE.}

\item{...}{Additional arguments to be passed to plot.acf}
}
\value{
A data frame with 1 variable containing the values of ACF.
}
\description{
This function allows calculation of an autocorrelation function (ACF) for a dataset with multiple independent units (for example, data from several individuals, data from multiple dives by an individual animal, etc.). The groups (individual, dive, etc.) should be coded in a categorical variable. The function calculates correlation coefficients over all levels of the categorical variable, but respecting divisions between levels (for example, individual animals are kept separate).
}
\examples{
block_acf(
  resids = ChickWeight$weight,
  blocks = ChickWeight$Chick
)
}
