% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{Extract a sub-sample of data}
\usage{
extract(x, sampling_rate, tst, ted)
}
\arguments{
\item{x}{A vector or matrix of measurements. If x is a matrix, each column is treated as a separate measurement vector.}

\item{sampling_rate}{the sampling rate in Hz of the data in x.}

\item{tst}{Defines the start time in seconds of the interval to be extracted from x.}

\item{ted}{Defines the end time in seconds of the interval to be extracted from x.}
}
\value{
{\strong{X: }} A matrix containing a sub-sample of x. X has the same number of columns as x. The length of the sub-sample will be round(sampling_rate*(tend-tstart)) samples.
}
\description{
This function is used to extract a sub-sample of data from a vector or matrix.
}
\note{
Output sampling rate is the same as the input sampling rate.

If either tst or ted are beyond the length of x, non-existing samples will be replaced with NaN in X.
}
\examples{
BW <- beaked_whale
BW_subset <- extract(x = BW$A$data, sampling_rate = BW$A$sampling_rate, tst = 3, ted = 100)
}
