% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_cal.R
\name{apply_cal}
\alias{apply_cal}
\title{Implement a calibration on tag sensor data}
\usage{
apply_cal(X, cal, Tempr = NULL)
}
\arguments{
\item{X}{A tag sensor data list, or a matrix or vector containing tag sensor data}

\item{cal}{A calibration list for the data in X from, for example, spherical_cal.}

\item{Tempr}{a tag sensor data list or a vector of temperature measurements for use in temperature compensation.
If Tempr is not a sensor data list, it must be the same size and sampling rate as the data in \code{X}.
Tempr is only required if there is a tcomp item in the \code{cal} list.}
}
\value{
A tag sensor data structure (or a matrix or vector, if X was a matrix or vector) with the calibration implemented. Data size and sampling rate are the same as for the input data \code{X}, but units may have changed.
}
\description{
Given an appropriate set of calibration constants and information, this function will apply the calibration procedure to a tag sensor data set. Cal fields currently supported are: poly, cross, map, tcomp, tref
}
\examples{
A_cal <- apply_cal(harbor_seal$A,spherical_cal(harbor_seal$A$data))

}
