% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simnetfromtap.R
\name{simnetfromtap}
\alias{simnetfromtap}
\title{Simulates a network from parameters, abundances, traits and phylogeny provided}
\usage{
simnetfromtap(
  traits,
  abuns,
  paramsList,
  pems,
  tmatch_type_pem,
  tmatch_type_obs
)
}
\arguments{
\item{traits}{a named ("low"/"high") list of species-named trait data matrices for lower and higher trophic level;}

\item{abuns}{a named ("low"/"high") list of species-named abundance vectors for lower and higher trophic level;}

\item{paramsList}{a list of parameter values with six elements: [[1]] and [[2]]: two vectors of linear combination parameters (importance values, one vector for each trophic level); [[3]]: a single shift parameter added to linear combination of higher trophic level PEMs; [[4]]: a single trait matching parameter for the PEMs; [[5]]: a vector of trait matching parameters for observed traits; [[6]]: a non-negative scalar delta to weight the importance of abundances}

\item{pems}{a named ("low"/"high") list of two species-named data frames (PEMs of lower and higher trophic level);}

\item{tmatch_type_pem}{type of trait matching function for latent traits (any name accepted by \code{\link{tmatch}}, currently "normal" and "shiftlnorm");}

\item{tmatch_type_obs}{type of trait matching function for observed traits (see previous argument).}
}
\value{
A named interaction matrix.
}
\description{
The workhorse function of this package, called by various other functions to construct a bipartite interaction network
}
\details{
Details in here!
}
\references{
Benadi et al. in prep
}
\author{
Gita Benadi <gita.benadi@biom.uni-freiburg.de> and Carsten Dormann <carsten.dormann@biom.uni-freiburg.de>
}
