% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_meta.R
\name{tar_meta}
\alias{tar_meta}
\title{Read a project's metadata.}
\usage{
tar_meta(
  names = NULL,
  fields = NULL,
  targets_only = FALSE,
  complete_only = FALSE,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_meta()}
only returns metadata on these targets.
You can supply symbols
or \code{tidyselect} helpers like \code{\link[=all_of]{all_of()}} and \code{\link[=starts_with]{starts_with()}}.
If \code{NULL}, all names are selected.}

\item{fields}{Optional, names of columns/fields to select. If supplied,
\code{tar_meta()} only returns the selected metadata columns.
If \code{NULL}, all fields are selected.
You can supply symbols or \code{tidyselect} helpers
like \code{\link[=all_of]{all_of()}} and \code{\link[=starts_with]{starts_with()}}.
The \code{name} column is always included first
no matter what you select. Choices:
\itemize{
\item \code{name}: name of the target or global object.
\item \code{type}: type of the object: either \code{"function"} or \code{"object"}
for global objects, and \code{"stem"}, \code{"branch"},
\code{"map"}, or \code{"cross"} for targets.
\item \code{data}: hash of the output data.
\item \code{command}: hash of the target's deparsed command.
\item \code{depend}: hash of the immediate upstream dependencies of the target.
\item \code{seed}: random number generator seed with which the target was built.
A target's random number generator seed
is a deterministic function of its name. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can recover the seed of a completed target
with \code{tar_meta(your_target, seed)} and run \code{set.seed()}
on the result to locally recreate the target's initial RNG state.
\item \code{path}: A list column of paths to target data. Usually, each element
is a single path, but there could be multiple paths per target
for dynamic files (i.e. \code{tar_target(format = "file")}).
\item \code{time}: \code{POSIXct} object with the time the target's data in storage
was last modified. If the target stores no local file,
then the time stamp corresponds to the time the target last
ran successfully. Only targets that run commands have time stamps:
just non-branching targets and individual dynamic branches.
Displayed in the current time zone of the system.
If there are multiple outputs for that target, as with file targets,
then the maximum time is shown.
\item \code{size}: hash of the sum of all the bytes of the files at \code{path}.
\item \code{bytes}: total file size in bytes of all files in \code{path}.
\item \code{format}: character, one of the admissible data storage formats.
See the \code{format} argument in the \code{\link[=tar_target]{tar_target()}} help file for details.
\item \code{iteration}: character, either \code{"list"} or \code{"vector"}
to describe the iteration and aggregation mode of the target. See the
\code{iteration} argument in the \code{\link[=tar_target]{tar_target()}} help file for details.
\item \code{parent}: for branches, name of the parent pattern.
\item \code{children}: list column, names of the children of targets that
have them. These include buds of stems and branches of patterns.
\item \code{seconds}: number of seconds it took to run the target.
\item \code{warnings}: character string of warning messages
from the last run of the target.
\item \code{error}: character string of the error message if the target errored.
}}

\item{targets_only}{Logical, whether to just show information about targets
or also return metadata on functions and other global objects.}

\item{complete_only}{Logical, whether to return only complete rows
(no \code{NA} values).}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame with one row per target/object and the selected fields.
}
\description{
Read the metadata of all recorded targets and global objects.
}
\details{
A metadata row only updates when the target is built.
\code{\link[=tar_progress]{tar_progress()}} shows information on targets that are running.
That is why the number of branches may disagree between \code{\link[=tar_meta]{tar_meta()}}
and \code{\link[=tar_progress]{tar_progress()}} for actively running pipelines.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_meta()
tar_meta(starts_with("y_")) # see also all_of()
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
