% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxon_relations.R, R/add_concept.R
\name{taxon_relations}
\alias{taxon_relations}
\alias{taxon_relations.taxlist}
\alias{taxon_relations,taxlist-method}
\alias{taxon_relations<-}
\alias{taxon_relations<-.taxlist}
\alias{taxon_relations<-,taxlist-method}
\alias{update_concept,taxlist,numeric-method}
\title{Retrieve or replace slot taxonRelations in taxlist objects}
\usage{
taxon_relations(taxlist, ...)

\method{taxon_relations}{taxlist}(taxlist, ...)

taxon_relations(taxlist, ...) <- value

\method{taxon_relations}{taxlist}(taxlist, ...) <- value

\S4method{update_concept}{taxlist,numeric}(taxlist, ConceptID, ...)
}
\arguments{
\item{taxlist}{A \linkS4class{taxlist} object.}

\item{...}{Further arguments passed among methods.}

\item{value}{A \code{data.frame} object to be set as slot \code{taxonRelations}.}

\item{ConceptID}{Concept IDs to be updated.}
}
\value{
An object of class \linkS4class{taxlist} with added names and
concepts.
}
\description{
Retrieve the content of slot \code{taxonRelations} from a
\linkS4class{taxlist} object or replace it by a new data frame.
}
\details{
The replacement method \verb{taxon_relations<-} should be only used when
constructing \linkS4class{taxlist} objects from an empty one
(prototype).

New concepts should be first added to a \linkS4class{taxlist} object
using their respective accepted names.
Synonyms can be further provided using the function \code{\link[=add_synonym]{add_synonym()}}.

Additional named vectors can be provided to be included in slot \code{taxonNames},
in the cases where those variables already exist, otherwise they will be
ignored.

It is recommended also to provide a concept view as \code{ViewID} (see
\code{\link[=taxon_views]{taxon_views()}}).
For adding a new view, use \code{\link[=add_view]{add_view()}}.
}
\examples{
## Subset for the genus Euclea and display of slot 'taxonNames'
Euclea <- subset(x = Easplist, subset = charmatch("Euclea", TaxonName),
  slot = "names", keep_children = TRUE)
Euclea
taxon_relations(Euclea)
}
\seealso{
\linkS4class{taxlist}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
