% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circles.r
\name{circles}
\alias{circles}
\alias{sample_circle}
\alias{sample_circles_interlocked}
\title{Sample (with noise) from circles}
\usage{
sample_circle(n, bins = 1L, sd = 0)

sample_circles_interlocked(n, bins = 1L, sd = 0)
}
\arguments{
\item{n}{Number of observations.}

\item{bins}{Number of intervals to stratify by. Default set to 1, which
generates a uniform sample.}

\item{sd}{Standard deviation of (independent multivariate) Gaussian noise.}
}
\description{
These functions generate uniform and stratified samples from
configurations of circles of radius 1 in 2- or 3-dimensional space,
optionally with noise.
}
\details{
The function \code{sample_circle()} uses the usual sinussoidal parameterization
from the unit interval to the unit circle.

The function \code{sample_circles_interlocked()} effectively samples from a pair
of circles and rotates them in 3-dimensional space so that they are
interlocked (perpendicular to each other).

Both functions are length-preserving and admit stratification. If \code{bins = 2},
the stratification for the latter function will simply be between the two
interlocked circles.
}
\examples{
set.seed(14312L)

# circle in 2-space
x <- sample_circle(120, sd = .1)
plot(x, asp = 1, pch = 19, cex = .5)

# interlocked circles in 3-space
x <- sample_circles_interlocked(120, sd = .1)
pairs(x, asp = 1, pch = 19, cex = .5)
}
