expect_skip <- function(code) {
  tryCatch(
    {
      skipped <- TRUE
      code
      skipped <- FALSE
    },
    skip = function(e) NULL
  )
  expect(skipped, "skip not active")
}

test_that("Package checks", {
  expect_skip(skip_if_not_installed("testthat", "9999.9999.999"))
  expect_skip(skip_if_not(FALSE))
  expect_skip(skip_if(TRUE))
})

test_that("Skip env vars", {
  expect_skip_with_env <- function(new, skip_fun) {
    withr::with_envvar(new, expect_skip(skip_fun()))
  }
  expect_skip_with_env(c("NOT_CRAN" = "false"), skip_on_cran)
  expect_skip_with_env(c("TRAVIS" = "true"), skip_on_travis)
  expect_skip_with_env(c("APPVEYOR" = "True"), skip_on_appveyor)
  expect_skip_with_env(c("BBS_HOME" = "asdf"), skip_on_bioc)
})

test_that("autogenerated message is always single line", {
  a_very_long_argument_name <- FALSE

  cnd <- capture_condition(skip_if_not(
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name ||
    a_very_long_argument_name
  ))

  expect_length(cnd$message, 1)
})
