% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,remstimate-method}
\alias{extract,remstimate-method}
\alias{extract.remstimate}
\title{\code{\link{extract}} method for \code{remstimate} objects}
\usage{
\S4method{extract}{remstimate}(
  model,
  include.nobs = TRUE,
  include.aic = TRUE,
  include.aicc = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  post.mean = FALSE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.aicc}{Report Corrected Akaike's Information Criterion (AICc) in
the GOF block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{post.mean}{Report the posterior means, rather than the posterior modes,
as coefficients?}

\item{...}{Custom parameters, which are handed over to subroutines. Currently
not in use.}
}
\description{
\code{\link{extract}} method for \code{remstimate} objects created by the
\code{\link[remstimate]{remstimate}} function in the \pkg{remstimate}
package.
}
