% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtabulate.R
\name{mtabulate}
\alias{mtabulate}
\alias{as_list}
\title{Tabulate Frequency Counts for Multiple Vectors}
\usage{
mtabulate(vects)

as_list(mat, nm = rownames(mat))
}
\arguments{
\item{vects}{A \code{\link[base]{vector}}, \code{\link[base]{list}}, or
\code{\link[base]{data.frame}} of named/unnamed vectors.}

\item{mat}{A matrix of counts.}

\item{nm}{A character vector of names to assign to the list.}
}
\value{
\code{mtabulate} - Returns a \code{\link[base]{data.frame}} with columns equal to
number of unique elements and the number of rows equal to the the original
length of the \code{\link[base]{vector}}, \code{\link[base]{list}}, or
\code{\link[base]{data.frame}} (length equals ncols in
\code{\link[base]{data.frame}}).  If list of vectors is named
these will be the rownames of the dataframe.

\code{as_list} - Returns a list of elements.
}
\description{
\code{mtabulate} - Similar to \code{\link[base]{tabulate}} that works on multiple vectors.

\code{as_list} - Convert a count matrix to a named list of elements.  The
semantic inverse of \code{mtabulate}.
}
\examples{
mtabulate(list(w=letters[1:10], x=letters[1:5], z=letters))
mtabulate(list(mtcars$cyl[1:10]))

## Dummy coding
mtabulate(mtcars$cyl[1:10])
mtabulate(CO2[, "Plant"])

dat <- data.frame(matrix(sample(c("A", "B"), 30, TRUE), ncol=3))
mtabulate(dat)
as_list(mtabulate(dat))
t(mtabulate(dat))
as_list(t(mtabulate(dat)))
}
\references{
\url{http://stackoverflow.com/a/9961324/1000343}
}
\seealso{
\code{\link[base]{tabulate}}
}
\author{
Joran Elias and Tyler Rinker <tyler.rinker@gmail.com>.
}
\keyword{frequency}
\keyword{tabulate}
