% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_thai_preamble.R
\name{use_thai_preamble}
\alias{use_thai_preamble}
\title{Create a \LaTeX Preamble for Thai Language in R Markdown}
\usage{
use_thai_preamble(
  name = "thai-preamble.tex",
  thai_font = "TH Sarabun New",
  line_spacing = 1.5,
  open = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{name}{(Character) Thai \LaTeX preamble file name or path of file to create, which can be relative path or absolute path. Default value is \code{thai-preamble.tex}.}

\item{thai_font}{(Character) Name of the Thai font to use. Default font is "TH Sarabun New". It can be any Thai font that installed in your system.}

\item{line_spacing}{(Numeric) Spacing between each line. Line spacing 1.5 is recommended for Thai language (default).}

\item{open}{(Logical) Open the newly created file for editing? Using default editor of \code{.tex} to open.}

\item{overwrite}{(Logical) If file already exist, do you want to overwrite?}
}
\value{
(Invisible) A path to \LaTeX preamble being created.
}
\description{
This function creates \LaTeX preamble file needed to render Thai language in R Markdown to a PDF document.
}
\details{
Here is the steps:
\enumerate{
\item Call \code{use_thai_preamble()}. You can set other file name by \code{name} argument and Thai font to use by \code{thai_font} argument.
\item Follow the instructions printed to R console.
\itemize{
\item File \code{thai-preamble.tex} should be created in the current working directory (by default).
\item (If not already) Create R Markdown file with \verb{pdf_document:} or \code{bookdown::pdf_document2} format.
\item Modify YAML header  in \verb{pdf_document:} or \code{bookdown::pdf_document2} option. Set \code{latex_engine} to \code{xelatex} and set to include path to the \LaTeX preamble file.
\item Add \LaTeX macro \verb{\\sloppy} to the beginning of the body of R Markdown (just after YAML header).
}
\item Write some Thai language in R Markdown then knit to PDF. It's DONE!
}
}
\examples{
\dontrun{
 # Running this will write `thai-preamble.tex` to your working directory
 use_thai_preamble()
 # Write `thai-preamble.tex` under pre-tex/ directory (a directory must exist)
 use_thai_preamble(name = "pre-tex/thai-preamble.tex")
 # Specify Thai font to use
 use_thai_preamble(thai_font = "Laksaman")
}

 # Example
 .old_wd <- setwd(tempdir())
 use_thai_preamble()
 setwd(.old_wd)
}
