% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_rbind_report.R
\name{summary.rbind_report}
\alias{summary.rbind_report}
\alias{summary_rbind_report}
\title{Print a summary of a merge report}
\usage{
\method{summary}{rbind_report}(object, ..., ref_label = "reference", target_label = "target")
}
\arguments{
\item{object}{a list generated by \code{\link[=rbind_dry_run]{rbind_dry_run()}}}

\item{...}{unused (necessary for compatibility with generic function)}

\item{ref_label}{the label for the reference dataset (defaults to
"reference")}

\item{target_label}{the label for the target dataset (defaults to "target")}
}
\value{
NULL (prints a summary to the console)
}
\description{
This function creates a summary of the merge report generated by
\code{\link[=rbind_dry_run]{rbind_dry_run()}}
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Create a second gen_tibble to merge
test_indiv_meta <- data.frame(
  id = c("x", "y", "z"),
  population = c("pop1", "pop1", "pop2")
)
test_genotypes <- rbind(
  c(1, 1, 0, 1, 1, 0),
  c(2, 1, 0, 0, 0, 0),
  c(2, 2, 0, 0, 1, 1)
)
test_loci <- data.frame(
  name = paste0("rs", 1:6),
  chromosome = paste0("chr", c(1, 1, 1, 1, 2, 2)),
  position = as.integer(c(3, 5, 65, 343, 23, 456)),
  genetic_dist = as.double(rep(0, 6)),
  allele_ref = c("A", "T", "C", "G", "C", "T"),
  allele_alt = c("T", "C", NA, "C", "G", "A")
)

test_gt <- gen_tibble(
  x = test_genotypes,
  loci = test_loci,
  indiv_meta = test_indiv_meta,
  valid_alleles = c("A", "T", "C", "G"),
  quiet = TRUE
)

# Merge the datasets using rbind
report <- rbind_dry_run(
  ref = example_gt, target = test_gt,
  flip_strand = TRUE, quiet = TRUE
)

# Get the summary
summary(report)
}
