% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{tigris_cache_dir}
\alias{tigris_cache_dir}
\title{Set the cache directory to store shapefiles with tigris}
\usage{
tigris_cache_dir(path)
}
\arguments{
\item{path}{The full path to the desired cache directory}
}
\description{
By default, tigris uses the rappdirs package to determine a suitable location to store shapefiles
on the user's computer.  However, it is possible that the user would want to store shapefiles in a custom
location.  This function allows users to set the cache directory, and stores the result in the user's
.Renviron so that tigris will remember the location.

Windows users: please note that you'll need to use double-backslashes or forward slashes
when specifying your cache directory's path in R.
}
\examples{
\dontrun{
# Set the cache directory
tigris_cache_dir('PATH TO MY NEW CACHE DIRECTORY')

# Check to see if it has been set correctly
Sys.getenv('TIGRIS_CACHE_DIR')
}
}
