% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlo.R
\name{dlo_dynamics}
\alias{dlo_dynamics}
\title{Dynamics function of the DLO model}
\usage{
dlo_dynamics(x, dxdt, q, dt, eta, zeta)
}
\arguments{
\item{x}{Numeric.
The current state of the system (value of the latent score).}

\item{dxdt}{Numeric.
The derivative of the state (rate of change of the latent score).}

\item{q}{Numeric. 
The damping coefficient.}

\item{dt}{Numeric.
The time step.}

\item{eta}{Numeric. 
The eta parameter of the DLO model.}

\item{zeta}{Numeric. 
The zeta parameter of the DLO model.}
}
\value{
A numeric vector containing the updated derivative of the state.
}
\description{
This function calculates the dynamics of a system using the DLO (Damped Linear Oscillator) model based on Equation 1 (Ollero et al., 2023).
The DLO model is a second-order differential equation that describes the behavior of a damped harmonic oscillator.
The function takes in the current state of the system, the derivative of the state, the damping coefficient, the time step,
and the values of the eta and zeta parameters. It returns the updated derivative of the state.
}
\references{
Ollero, M. J. F., Estrada, E., Hunter, M. D., & Cancer, P. F. (2023).
 Characterizing affect dynamics with a damped linear oscillator model: Theoretical considerations and recommendations for individual-level applications. 
 \emph{Psychological Methods}. 
\doi{10.1037/met0000615}
}
