% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_feature_importance.R
\name{plot_feature_importance}
\alias{plot_feature_importance}
\title{SHAP value based Feature Importance plot}
\usage{
plot_feature_importance(
  treeshap,
  desc_sorting = TRUE,
  max_vars = ncol(shaps),
  title = "Feature Importance",
  subtitle = NULL
)
}
\arguments{
\item{treeshap}{A treeshap object produced with the \code{\link{treeshap}} function. \code{\link{treeshap.object}}.}

\item{desc_sorting}{logical. Should the bars be sorted descending? By default TRUE.}

\item{max_vars}{maximum number of variables that shall be presented. By default all are presented.}

\item{title}{the plot's title, by default \code{'Feature Importance'}.}

\item{subtitle}{the plot's subtitle. By default no subtitle.}
}
\value{
a \code{ggplot2} object
}
\description{
This function plots feature importance calculated as means of absolute values of SHAP values of variables (average impact on model output magnitude).
}
\examples{
\donttest{
library(xgboost)
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
target <- fifa20$target
param <- list(objective = "reg:squarederror", max_depth = 3)
xgb_model <- xgboost::xgboost(as.matrix(data), params = param, label = target,
                              nrounds = 20, verbose = FALSE)
unified_model <- xgboost.unify(xgb_model, as.matrix(data))
shaps <- treeshap(unified_model, as.matrix(head(data, 3)))
plot_feature_importance(shaps, max_vars = 4)
}
}
\seealso{
\code{\link{treeshap}} for calculation of SHAP values

\code{\link{plot_contribution}}, \code{\link{plot_feature_dependence}}, \code{\link{plot_interaction}}
}
