% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/period.R
\name{yearweek}
\alias{yearweek}
\alias{is_53weeks}
\alias{yearmonth}
\alias{yearquarter}
\title{Represent year-week (ISO), year-month or year-quarter objects}
\usage{
yearweek(x)

is_53weeks(year)

yearmonth(x)

yearquarter(x)
}
\arguments{
\item{x}{Other object.}

\item{year}{A vector of years.}
}
\value{
Year-week (\code{yearweek}), year-month (\code{yearmonth}) or year-quarter
(\code{yearquarter}) objects.

\code{TRUE}/\code{FALSE} if the year has 53 ISO weeks.
}
\description{
Create or coerce using \code{yearweek()}, \code{yearmonth()}, or \code{yearquarter()}
}
\details{
It's a known issue that these attributes will be dropped when using
\link{group_by} and \link{mutate} together. It is recommended to \link{ungroup} first, and
then use \link{mutate}.
}
\section{Index functions}{

The tsibble \code{yearmonth()} and \code{yearquarter()} function preserve the time zone of
the input \code{x}, contrasting to their zoo counterparts.
}

\examples{
# coerce POSIXct/Dates to yearweek, yearmonth, yearquarter ----
x <- seq(as.Date("2016-01-01"), as.Date("2016-12-31"), by = "1 month")
yearweek(x)
yearmonth(yearweek(x)); yearmonth(x)
yearquarter(x)

# coerce numerics to yearmonth, yearquarter ----
yearmonth(seq(2010, 2017, by = 1 / 12))
yearquarter(seq(2010, 2017, by = 1 / 4))

# coerce yearmonths to yearquarter ----
y <- yearmonth(x)
yearquarter(y)

# S3 method seq() ----
wk1 <- yearweek(as.Date("2017-11-01"))
wk2 <- yearweek(as.Date("2018-04-29"))
seq(from = wk1, to = wk2, by = 2) # by two weeks
mth <- yearmonth(as.Date("2017-11-01"))
seq(mth, length.out = 5, by = 1) # by 1 month
seq(yearquarter(mth), length.out = 5, by = 1) # by 1 quarter
is_53weeks(2015:2016)
}
\seealso{
\link{pull_interval}
}
