% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_parent.R
\name{match_parent}
\alias{match_parent}
\title{Vind een matchende parent in een referentielijst}
\usage{
match_parent(taxa, ref_taxa, n_parents = 5, verbose = FALSE)
}
\arguments{
\item{taxa}{Een vector met taxa}

\item{ref_taxa}{Een vector met referentie-taxa}

\item{n_parents}{Het aantal parentniveau's dat gecheckt wordt. Default is 5.}

\item{verbose}{Als \code{TRUE} geeft the functie een message met de \code{taxa} waar geen match voor is.}
}
\value{
Een vector met taxa die in de lijst met referentie-taxa voorkomen.
\itemize{
\item Als de soort in de referentie-taxa wordt gevonden, dan wordt deze geretourneerd.
\item Als de soort niet, maar wel een parent is gevonden in de lijst met referentie-taxa wordt deze geretourneerd.
\item Als de soort of parent niet is gevonden in de lijst met referentie-taxa wordt \code{NA}  geretourneerd.
}
}
\description{
Met deze functie is met mogelijk om van een taxon een parent in de TWN-lijst te vinden die in een lijst met
referentie-taxa voorkomt. Dit kan bijv. nuttig zijn als het taxon een ondersoort is van een soort die in
een beoordelingssysteem voorkomt. De functie kan dan worden gebruikt om de soortenlijst geschikt te maken
voor een beoordelingssysteem.
}
\examples{

ref <- c("Bufonidae", "kameel")
namen <- c("Bufo calamita", "Bufo", "Bufonidae", "Bufo bufo", "Buf", NA, "zebra")

match_parent(namen, ref)

}
