% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HSgraph.R
\encoding{UTF-8}
\name{HSgraph}
\alias{HSgraph}
\title{Suitability values distribution graph}
\usage{
HSgraph(mat, breaks = 10, hist.total = TRUE)
}
\arguments{
\item{mat}{A matrix with two columns. The first column must contain the
suitability values (i.e., the classification rule); the second column must
contain the presences and absences.}

\item{breaks}{Number of cells for the total histogram. By default,
\code{breaks} = 10.}

\item{hist.total}{Logical. Indicates whether or not the distribution of
suitability values for all the cases together is graphed.}
}
\value{
This function returns a multiple histogram.
}
\description{
A function to visualize the distribution of the suitability
values associated to presences, absences, and all cases together.
}
\details{
In blue, the distribution of the suitability values associated to
presences. In red, the distribution of the suitability values associated to
absences. This graph helps to understand why the \emph{AUC} (or \emph{Se*})
is greater, equal to, or less than the \emph{uAUC} (or \emph{uSe*}) (see
Jiménez-Valverde 2022).
}
\examples{
suit<-rbeta(100, 2, 2) # Generate suitability values
random<-runif(100)
sp<-ifelse(random < suit, 1 , 0) # Generate presence-absence data
HSgraph(cbind(suit, sp), breaks = 20, hist.total = TRUE)
}
\references{
Jiménez-Valverde, A. (2022). The uniform AUC: dealing with the
    representativeness effect in presence-absence models. \emph{Methods Ecol.
    Evol.}, 13, 1224-1236.
}
