% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.prop.ps}
\alias{meta.lm.prop.ps}
\title{Meta-regression analysis for paired-samples proportion differences}
\usage{
meta.lm.prop.ps(alpha, f11, f12, f21, f22, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{vector of frequencies in cell 1,1}

\item{f12}{vector of frequencies in cell 1,2}

\item{f21}{vector of frequencies in cell 2,1}

\item{f22}{vector of frequencies in cell 2,2}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients
in a meta-regression model where the dependent variable is a
paired-samples proportion difference. The estimates are OLS
estimates with standard errors that accommodate residual
heteroscedasticity.
}
\examples{
f11 <- c(40, 20, 25, 30)
f12 <- c(3, 2, 2, 1)
f21 <- c(7, 6, 8, 6)
f22 <- c(26, 25, 13, 25)
x1 <- c(1, 1, 4, 6)
x2 <- c(1, 1, 0, 0)
X <- matrix(cbind(x1, x2), 4, 2)
meta.lm.prop.ps(.05, f11, f12, f21, f22, X)

# Should return: 
#       Estimate         SE          z     p          LL         UL
# b0 -0.21113402 0.21119823 -0.9996960 0.317 -0.62507494 0.20280690
# b1  0.02185567 0.03861947  0.5659236 0.571 -0.05383711 0.09754845
# b2  0.12575138 0.17655623  0.7122455 0.476 -0.22029248 0.47179524


}
\references{
\insertRef{Bonett2014}{vcmeta}
}
