% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{use_svgzoom}
\alias{use_svgzoom}
\title{Setup for interactive Vtree}
\usage{
use_svgzoom(
  minheight = "200px",
  cursor_all = "all-scroll",
  overflow = "inherit !important",
  position = "sticky",
  fill = "transparent",
  cursor_text = "pointer",
  init_event = c("mouseenter", "click", "dblclick"),
  onwindow_resize = TRUE,
  shortcuts = TRUE
)
}
\arguments{
\item{minheight}{minimum height in \code{"px"}. Default is "200px".}

\item{cursor_all}{The cursor symbol for the whole SVG. Default is "all-scroll".}

\item{overflow}{Overflow value for the whole SVG. Default is "inherit".}

\item{position}{CSS position of the SVG. Default is "sticky".}

\item{fill}{Fill color for the SVG background. Default is "transparent".}

\item{cursor_text}{The cursor symbol for text nodes. Default is "pointer".}

\item{init_event}{The mouse event to activate zooming and panning.
Default is \code{mouseenter}.}

\item{onwindow_resize}{Should the SVG be resized when the window size changes?
Default is \code{TRUE}.}

\item{shortcuts}{Should Keyboard shortcuts be used to control the SVG?
Default is \code{TRUE}.}
}
\description{
This function must be called in the UI, in order to make the \code{\link{vtree}} interactive.
}
\examples{
\dontrun{
library(shiny)
library(vtree)

ui <- fluidPage(
  use_svgzoom(),
  helpText(div(style="font-weight: 800; font-size: large; color: black;",
               HTML("Zooming and Panning is possible with mouse-drag ",
                    "and mouse-wheel <br>, or with shortcuts;",
                    " +,- and arrow-keys and CTRL+Backspace to",
                    " resize+fit+center the svg.."))),
  vtreeOutput("vtree", width = "100\%", height = "500px")
)

server <- function(input, output, session) {
  output$vtree <- renderVtree({
    vtree(FakeData,"Severity Sex",
          labelnode=list(Sex=(c("Male"="M","Female"="F"))),
          pngknit=FALSE)
  })
}

shinyApp(ui, server)
}
}
\seealso{
\code{\link{vtreeOutput}}, \code{\link{vtree}}

Other Shiny Functions: 
\code{\link{init_js}()},
\code{\link{inlineCssSetup}()},
\code{\link{renderVtree}()},
\code{\link{vtreeOutput}()}
}
\concept{Shiny Functions}
