% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_dt.R
\name{wt_dt}
\alias{wt_dt}
\alias{as.wt_dt}
\alias{is.wt_dt}
\title{An S3 class, based on \link{data.table}, to store webtrack data}
\usage{
as.wt_dt(x)

is.wt_dt(x)
}
\arguments{
\item{x}{\link{data.table} containing the correct set of variables (panelist_id,url and timestamp)}
}
\value{
a webtrack data object

logical. TRUE if x is a webtrack data object and FALSE otherwise
}
\description{
An S3 class, based on \link{data.table}, to store webtrack data
}
\details{
A \code{wt_dt} table is a \link{data.table}.
Therefore, it can be used by any function that would work on a \link{data.frame} or a \link{data.table}.
Most of the operation such as variable creation, subsetting and joins are inherited from the \link{data.table}
\verb{[]} operator, following the convention \code{DT[i,j,by]} (see data table package for detail).
These operations are applied on the data.
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
is.wt_dt(wt)
}
\seealso{
\itemize{
\item \link{data.table} -- on which \code{wt_dt} is based
}
}
