% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{GetWikidataitem}
\alias{GetWikidataitem}
\title{GetWikidataitem
Use Wikimedia_query to obtain the Wikidata entity of a article from a Wikimedia project.
Automatically resolvs redirects.}
\usage{
GetWikidataitem(article = "", project = "en.wikipedia.org")
}
\arguments{
\item{article}{Article to search}

\item{project}{Wikimedia project, defaults "en.wikipedia.org"}
}
\value{
A vector with the firts element to 1 if exists the Wikidata item and if not a
disambiguation page, the second element de normalized forma of article, and the third the wikidata item. If errors, the firts element is set to 0 and the third is the explication of error.
}
\description{
GetWikidataitem
Use Wikimedia_query to obtain the Wikidata entity of a article from a Wikimedia project.
Automatically resolvs redirects.
}
\examples{
GetWikidataitem('Max Planck', project='es.wikipedia.org')

GetWikidataitem('Max')

GetWikidataitem('Cervante')
}
\author{
Angel F. Zazo, Departament of Computer Science and Automatics, University of Salamanca
}
