% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_topic}
\alias{wb_topic}
\title{World Bank topic data}
\source{
\url{https://api.worldbank.org/v2/topics}
}
\usage{
wb_topic(topic = NULL, lang = "en")
}
\arguments{
\item{topic}{(\code{NULL} | \code{character()})\cr
Topic to query. Default \code{NULL}. If \code{NULL}, all topics are returned.}

\item{lang}{(\code{character(1)})\cr
Language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available topics. The columns are:
\item{id}{The topic ID.}
\item{value}{The topic value.}
\item{source_note}{The source note.}
}
\description{
List all topics supported by the World Bank API.
}
\examples{
\dontshow{if (httr2::is_online()) withAutoprint(\{ # examplesIf}
topic <- wb_topic()
head(topic)
\dontshow{\}) # examplesIf}
}
\seealso{
Other indicators data: 
\code{\link{wb_country}()},
\code{\link{wb_income_level}()},
\code{\link{wb_indicator}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_region}()},
\code{\link{wb_source}()}
}
\concept{indicators data}
