% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parModel.R
\name{MClapply}
\alias{MClapply}
\title{MultiCore apply of library parallel.}
\usage{
MClapply(pop, EvalGene, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{EvalGene}{Function for evaluating a gene.}

\item{lF}{Local function configuration which provides 
all functions needed in \code{EvalGene()}.}
}
\value{
Fitness vector.
}
\description{
The evaluation of the fitness of the genes of the population
is distributed to one worker on each core of the CPU of the 
local machine.
The package of \code{parallel} of base R is used.
The number of cores is provided by \code{lF$Cores}.
}
\details{
Be aware that
\itemize{
\item \code{parallel::mclapply()} assumes that each function evaluation 
      needs approximately the same time.
\item Best results are obtained if \code{popsize} modulo \code{cores-1} is 0.
\item Does not work on Windows.
}
}
\examples{
library(parallelly) 
if (supportsMulticore()){
lFxegaGaGene$Cores<-function() {2}
pop<-xegaInitPopulation(1000, lFxegaGaGene)
popnew<-MClapply(pop, lFxegaGaGene$EvalGene, lFxegaGaGene)
}

}
\seealso{
Other Execution Model: 
\code{\link{PparLapply}()},
\code{\link{futureLapply}()}
}
\concept{Execution Model}
