% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{edit_model}
\alias{edit_model}
\title{Edit a model}
\usage{
edit_model(zoltar_connection, model_url, model_config)
}
\arguments{
\item{zoltar_connection}{A \code{ZoltarConnection} object as returned by \code{\link[=new_connection]{new_connection()}}}

\item{model_url}{url of a project in zoltar_connection's projects. this is the project the new model will be edited
in}

\item{model_config}{A \code{list} containing a Zoltar model configuration. An example: example-model-config.json .
Full documentation at \url{https://docs.zoltardata.com/}.}
}
\description{
Edits the model in the passed project using the passed list. Fails if a model with the passed name already exists.
}
\examples{
\dontrun{
  edit_model(conn, "https://www.zoltardata.com/api/model/2/",
    jsonlite::read_json("example-model-config.json"))
}
}
