% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_argentinian_holidays.R
\name{get_argentinian_holidays}
\alias{get_argentinian_holidays}
\title{Get Official Holidays in Argentina for a Given Year}
\usage{
get_argentinian_holidays(year = NULL)
}
\arguments{
\item{year}{An integer representing the year (between 2016 and current year). Defaults to the current year.}
}
\value{
A data frame with the following columns:
\itemize{
  \item \code{fecha}: Date of the holiday (character in YYYY-MM-DD format).
  \item \code{tipo}: Type of holiday (e.g., "inamovible", "trasladable").
  \item \code{nombre}: Name or reason of the holiday.
}
Returns \code{NULL} if the API is unavailable or returns an error.
}
\description{
This function retrieves the list of official holidays in Argentina for a specified year.
The data is obtained from the public API at \url{https://api.argentinadatos.com/v1/feriados/}.
You can append the desired year at the end of the URL. For example:
\url{https://api.argentinadatos.com/v1/feriados/2024/}
If no year is provided, the function returns holidays for the current year.
}
\details{
The function sends a GET request to the ArgentinaDatos API and converts the JSON response into a structured
data frame. It validates the input year and falls back to the current year if none is specified.
If the API does not return a 200 status code or is unavailable, the function will return \code{NULL} and emit a message.
}
\note{
Requires an active internet connection. If the API is unavailable or its structure changes,
the function may need updates.
}
\examples{
\dontrun{
# Get holidays for the year 2025
feriados_2025 <- get_argentinian_holidays(2025)
print(feriados_2025)

# Get holidays for the current year
feriados_actual <- get_argentinian_holidays()
View(feriados_actual)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}
}
