
#' @title  Simulate a sample of group covariance, Omega
#' @description  Simulate a sample of group covariance, Omega from its posterior (Inverse Wishart)
#'
#' @param model.attributes  Model attributes generated by \code{initialize.model.attributes}
#' @param hyp.parm  Hyperparameters generated by \code{initialize.hyp.parm}
#' @param parm  The whole parameters from current iteration
#'
#' @importFrom stats rgamma
#' @importFrom LaplacesDemon rinvwishart
#'
#' @return  A sample of Omega
#' @noRd
#' 

simulated.omega = function(model.attributes, hyp.parm, parm){
  
  X.matrix = apply(parm$X, 2, c)
  Z.vector = as.vector(parm$Z)
  Omegasum = array(0,c(model.attributes$G,model.attributes$L,model.attributes$L))
  
  # Simulate the Omega matrix for the first group. This is a diagonal matrix
  g = 1
  t.difference = t(X.matrix[Z.vector == g,]) - parm$mu[g,]
  sum.squares = apply(t.difference^2,1,sum)
  # if(l>1), and if(L=1), change the following line. 
  if(model.attributes$L==1){
    parm$omega[g,,]<- 1 / rgamma(model.attributes$L,
                                 shape = hyp.parm$omega.diag.nu + sum(Z.vector == g)/2, 
                                 rate = hyp.parm$omega.psi[g,,] + sum.squares/2)
  }else{diag(parm$omega[g,,]) <- 1 / rgamma(model.attributes$L, 
                                            shape = sum(Z.vector == g)/2 + hyp.parm$omega.diag.nu, 
                                            rate = diag(hyp.parm$omega.psi[g,,]) + sum.squares/2)
  }
  
  # If there are 2 or more groups and more than 1 factor, simulate the Omega matrix for those groups
  if(model.attributes$G > 1 & model.attributes$L>1) for(g in 2:model.attributes$G){ 
    t.difference = t(X.matrix[Z.vector == g,]) - parm$mu[g,]
    Omegasum[g,,] = t.difference %*% t(t.difference)
    parm$omega[g,,] <- rinvwishart(sum(Z.vector == g) + hyp.parm$omega.nu,
                                   hyp.parm$omega.psi[g,,] + Omegasum[g,,])
  }
  if(model.attributes$G > 1 & model.attributes$L==1) for(g in 2:model.attributes$G){ 
    t.difference = t(X.matrix[Z.vector == g,]) - parm$mu[g,]
    Omegasum[g,,] = t.difference %*% t(t.difference)
    parm$omega[g,,] <- 1/rgamma(model.attributes$L, 
                                shape = sum(Z.vector == g)/2 + hyp.parm$omega.nu,
                                rate = hyp.parm$omega.psi[g,,] + Omegasum[g,,]/2)
  }
  return(parm)
}


