
#' @title  Simulate sample of probabilities, p
#' @description  Simulates a sample of probabilities from a Dirichlet distribution. The samples are generated without any constraints
#'
#' @param model.attributes  Model attributes generated by \code{initialize.model.attributes}
#' @param parm  The whole parameters from current iteration
#' @param hyp.parm  Hyperparameters generated by \code{initialize.hyp.parm}
#' 
#' @importFrom LaplacesDemon rdirichlet
#' @importFrom stats density
#'
#' @return  A sample of p
#' @noRd

simulated.probs <- function(model.attributes, parm, hyp.parm){
  probs.aux<-as.numeric(table(factor(parm$Z,levels=1:model.attributes$G)))
  
  if (model.attributes$G>1)
  {
    parm$probs <- rdirichlet(1,probs.aux + hyp.parm$p.exponent)
  } else {parm$probs <- c(1)}
  
  return(parm)
}


