% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCFM.fit.R
\name{BCFM.fit}
\alias{BCFM.fit}
\title{Fit BCFM Model}
\usage{
BCFM.fit(
  data,
  model.attributes,
  hyp.parm,
  n.iter = 50000,
  vague.mu = FALSE,
  covariance = TRUE,
  p.exponent = 2,
  every = 10
)
}
\arguments{
\item{data}{An array of dimensions (observations, variables, time points)}

\item{model.attributes}{Model attributes generated by initialize.model.attributes}

\item{hyp.parm}{Hyperparameters generated by initialize.hyp.parm}

\item{n.iter}{Number of MCMC iterations. Default is 50000.}

\item{vague.mu}{Logical indicating whether to use vague priors for mu.
Default is FALSE.}

\item{covariance}{Logical indicating whether to model covariance structure.
Default is TRUE.}

\item{p.exponent}{The Dirichlet priors exponent for probabilities. Default is 2.}

\item{every}{Integer specifying the frequency of progress updates during MCMC.
Default is 10.}
}
\value{
A list containing:
\describe{
\item{Result}{Output from the BCFMcpp C++ function}
\item{model.attributes}{The model attributes used}
\item{hyp.parm}{The hyperparameters used}
\item{start.time}{POSIXct timestamp when model started}
\item{end.time}{POSIXct timestamp when model completed}
\item{run.time}{Total elapsed time for model execution}
}
}
\description{
Fits a single Bayesian Clustering Factor Models (BCFM) using C++
implementation. This function serves as a wrapper for the BCFMcpp function,
handling timing and output formatting.
}
\examples{
\donttest{
# Prepare data using the included simulated dataset
data(sim.data)
data.pre <- init.data(sim.data, paste0("V", 1:5))

# Initialize model components
model.attributes <- initialize.model.attributes(S = nrow(sim.data), times = 1,
                                                 R = 5, L = 2, G = 2)
cluster.hyperparms <- initialize.cluster.hyperparms(data.pre, model.attributes)
hyp.parm <- initialize.hyp.parm(model.attributes, cluster.hyperparms)

# Fit model
result <- BCFM.fit(data.pre, model.attributes, hyp.parm,
                   n.iter = 100, every = 10)
result$run.time
}

}
\seealso{
\code{\link{BCFM.model.selection}} for fitting multiple models,
\code{\link{initialize.model.attributes}}, \code{\link{initialize.hyp.parm}}
}
