% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_oews.R
\name{get_oews_areas}
\alias{get_oews_areas}
\title{Download OEWS Area Definitions}
\usage{
get_oews_areas(ref_year, silent = TRUE, geometry = TRUE)
}
\arguments{
\item{ref_year}{Four-digit year (converted to integer). The year for which to retrieve OEWS area definitions. Valid values are 2024 through current release year. Prior years included Township codes, which change the structure of the file.}

\item{silent}{Logical. If TRUE (default), suppress console output}

\item{geometry}{Logical.  If TRUE (default), downloads shapefiles for OEWS area definitions using `tigris::counties()` and `tigris::shift_geometry()` to render Alaska, Hawaii, and Puerto Rico with a focus on the area of the continental United States.}
}
\value{
Data table which maps individual counties to OEWS area definitions.
  \itemize{
    \item fips_code - The State FIPS code
    \item state_name - The state name
    \item state_abb - The state two-character postal abbreviation
    \item oews_area_code - The OEWS area code defining the metropolitan area or nonmetropolitan area the county belongs to.
    \item oews_area_name - The OEWS area name
    \item county_code - The FIPS code for the county
    \item county_name - The county name
    }
}
\description{
Download OEWS Area Definitions
}
\examples{
\donttest{
 # Get OEWS area definitions without shapefiles and with processing messages.
 test <- get_oews_areas(ref_year = 2024, geometry = FALSE, silent = FALSE)
 
}

}
