% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_BBM.R
\name{EM_BBM.spatial}
\alias{EM_BBM.spatial}
\alias{EM_BBM.independent}
\title{EM Algorithms for Bayesian brain maps}
\usage{
EM_BBM.spatial(
  prior_mean,
  prior_var,
  meshes,
  BOLD,
  theta0,
  C_diag,
  H,
  Hinv,
  maxiter = 100,
  usePar = FALSE,
  epsilon = 0.001,
  reduce_dim = TRUE,
  verbose = FALSE
)

EM_BBM.independent(
  prior_mean,
  prior_var,
  BOLD,
  theta0,
  C_diag,
  H,
  Hinv,
  maxiter = 100,
  epsilon = 0.001,
  reduce_dim = FALSE,
  usePar = FALSE,
  verbose
)
}
\arguments{
\item{prior_mean}{(\eqn{V \times Q} matrix) mean maps for each network in the prior,
where \eqn{Q} is the number of networks, \eqn{V=nvox} is the number of data locations.}

\item{prior_var}{(\eqn{V \times Q} matrix) between-subject variance maps
for each network in prior}

\item{meshes}{\code{NULL} for spatial independence model, otherwise a list of
objects of class "BBM_mesh" containing the triangular mesh (see
\code{\link{make_mesh}}) for each brain structure.}

\item{BOLD}{(\eqn{V \times Q} matrix) dimension-reduced fMRI data}

\item{theta0}{(list) initial guess at parameter values: A (\eqn{QxQ} mixing matrix),
nu0_sq (residual variance from first level) and (for spatial model only)
kappa (SPDE smoothness parameter for each network map)}

\item{C_diag}{(\eqn{Qx1}) diagonal elements of matrix proportional to
residual variance.}

\item{H, Hinv}{For dimension reduction
of the spatial Bayesian brain map model, which assumes that all networks
have the same smoothness parameter, \eqn{\kappa}}

\item{maxiter}{Maximum number of EM iterations. Default: 100.}

\item{usePar}{Parallelize the computation? Default: \code{FALSE}. Can be the
number of cores to use or \code{TRUE}, which will use the number available minus two.
Not yet implemented for spatial Bayesian brain map.}

\item{epsilon}{Smallest proportion change between iterations. Default: 0.001.}

\item{reduce_dim}{Reduce the temporal dimension of the data using PCA?
Default: \code{TRUE} for the spatial EM algorithm, and \code{FALSE} for the
independent EM algorithm.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}
}
\value{
A list: theta (list of final parameter estimates), subjNet_mean
(estimates of subject-level networks), subjNet_var (variance of subject-level networks,
for non-spatial model) or subjNet_cov (covariance matrix of subject-level networks,
for spatial model -- note that only diagonal and values for neighbors are
computed), and success (flag indicating convergence (\code{TRUE}) or not
(\code{FALSE}))
}
\description{
EM Algorithms for Bayesian brain maps
}
\details{
\code{EM_BBM.spatial} implements the expectation-maximization
(EM) algorithm described in Mejia et al. (2019+) for estimating the
subject-level networks and unknown parameters in the Bayesian brain map
model with spatial priors on subject effects.

In both models, if original fMRI timeseries has covariance
\eqn{\sigma^2 I_T}, the prewhitened timeseries achieved by premultiplying
by (\eqn{QxT}) matrix \eqn{H} from PCA has diagonal covariance
\eqn{\sigma^2HH'}, so C_diag is \eqn{diag(HH')}.
}
