% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.ttest.OneSample}
\alias{BFpower.ttest.OneSample}
\title{Sample Size Determination for the One-Sample Bayesian t-Test}
\usage{
BFpower.ttest.OneSample(
  alternative,
  ROPE = NULL,
  prior_analysis,
  location,
  scale,
  dff,
  prior_design = NULL,
  location_d,
  scale_d,
  dff_d,
  N = NULL,
  type_rate = "positive",
  true_rate,
  false_rate,
  threshold,
  plot_power = FALSE,
  plot_rel = FALSE
)
}
\arguments{
\item{alternative}{Character. The direction of the alternative hypothesis : two-sided (\code{"two.sided"} ), right-sided (\code{"greater"}), or left-sided (\code{"less"}).}

\item{ROPE}{Optional numeric vector. Bounds for an interval null hypothesis.
\itemize{
\item For \code{hypothesis = "two.sided"}, must be a numeric vector of length 2 with distinct finite values.
\item For \code{"greater"}, must be a single numeric scalar > 0.
\item For \code{"less"}, must be a single numeric scalar < 0.
}}

\item{prior_analysis}{Character. The analysis prior under the alternative hypothesis:
\code{"Normal"}, \code{"Moment"} (normal-moment prior), or \code{"t-distribution"}.}

\item{location}{Numeric scaler. Location parameter for the analysis prior under the alternative hypothesis.}

\item{scale}{Numeric scaler. Scale parameter for the analysis prior under the alternative hypothesis (must be > 0).}

\item{dff}{Numeric scaler. Degrees of freedom for the analysis prior under the alternative hypothesis (required if \code{prior_analysis = "t-distribution"}).}

\item{prior_design}{Optional character. The design prior under the alternative hypothesis:
\code{"Normal"}, \code{"Moment"}, \code{"t-distribution"}, or \code{"Point"}.}

\item{location_d}{Numeric scaler. Location parameter for the design prior under the alternative hypothesis.}

\item{scale_d}{Numeric scaler. Scale parameter for the design prior under the alternative hypothesis.}

\item{dff_d}{Numeric scaler. Degrees of freedom for the design prior under the alternative hypothesis (required if \code{prior_design = "t-distribution"}).}

\item{N}{Numeric integer. Sample size.}

\item{type_rate}{Character. Either \code{"positive"} (controls true/false positive rates) or \code{"negative"} (controls true/false negative rates).}

\item{true_rate}{Numeric scaler. Target true positive or negative rate (between 0.6 and 0.999).}

\item{false_rate}{Numeric scaler. Target false positive or false negative rate (between 0.001 and 0.1).}

\item{threshold}{Numeric scaler. Threshold of compelling evidence (must be > 1).}

\item{plot_power}{Logical. If \code{TRUE}, plots power curve.}

\item{plot_rel}{Logical. If \code{TRUE}, plots the relationship between the BF and data.}
}
\value{
An object of class \code{BFpower_t} (a list) containing:
\describe{
\item{type}{Character, always "One-sample t-test".}
\item{alternative}{Character, the direction of the alternative hypothesis.}
\item{ROPE}{Optional numeric vector for interval null bounds.}
\item{analysis_h1}{List with the analysis prior parameters: \code{prior_analysis}, \code{location}, \code{scale}, and optionally \code{dff}.}
\item{design_h1}{List with the design prior parameters: \code{prior_design}, \code{location}, \code{scale}, and optionally \code{dff} (or \code{NULL} if not provided).}
\item{results}{Data frame of probabilities: compelling/misleading evidence, or \code{NaN} if calculation fails.}
\item{threshold}{Numeric, threshold of compelling evidence.}
\item{plot_power}{Logical, whether to plot the power curve.}
\item{plot_rel}{Logical, whether the relationship between the BF and t-value is plotted.}
}
}
\description{
Perform sample size determination or calculate the probability of obtaining
compelling or misleading evidence for a one-sample Bayesian t-test.
Can handle both point-null and interval-null hypothesis, and allows specifying
analysis and design priors.
}
\details{
\strong{1. Sample size determination mode (when \code{N = NULL}):}

If no sample size is provided, the function determines the minimum sample size. In this mode, the user
must supply the following arguments:
\itemize{
\item \code{type_rate} - either \code{"positive"} to control true/false positive rates,
or \code{"negative"} to control true/false negative rates.
\item \code{true_rate} - the targeted true positive or true negative rate (between 0.6 and 0.999).
\item \code{false_rate} - the acceptable false positive or false negative rate (between 0.001 and 0.1).
\item \code{threshold} - the Bayes factor threshold for compelling evidence (must be > 1).
}

The function iteratively finds the smallest sample size for which the probability
of obtaining compelling evidence meets or exceeds \code{true_rate}, while the
probability of misleading evidence does not exceed \code{false_rate}.

\strong{2. Fixed-sample analysis mode (when \code{N} is supplied):}

If a positive numeric sample size \code{N} is provided, the function computes
the probabilities of obtaining compelling or misleading evidence for that
fixed sample size. In this mode, the arguments \code{type_rate}, \code{true_rate},
and \code{false_rate} are ignored; only the Bayes factor threshold \code{threshold} is used.

\strong{Analysis Priors:}

The analysis prior specifies the prior distribution of the effect under the
alternative hypothesis. The user must provide:
\itemize{
\item \code{prior_analysis} - the type of prior: \code{"Normal"}, \code{"Moment"} (normal-moment prior), or \code{"t-distribution"}.
\item \code{location} - the mean or location of the prior.
\item \code{scale} - the standard deviation or scale (must be positive).
\item \code{dff} - degrees of freedom (required if \code{prior_analysis = "t-distribution"}).
}

\strong{Design Priors (optional):}

A design prior can be supplied to reflect uncertainty about the effect size
during study planning. If provided, the following must be supplied:
\itemize{
\item \code{prior_design} - the type of design prior: \code{"Normal"}, \code{"Moment"}, \code{"t-distribution"}, or \code{"Point"}.
\item \code{location_d} - the location of the design prior.
\item \code{scale_d} - the scale parameter (positive for all models except \code{"Point"}).
\item \code{dff_d} - degrees of freedom for \code{"t-distribution"} design priors.
}

\strong{interval null Hypothesis:}

The argument \code{ROPE} specifies the bounds of an interval null hypothesis.
If \code{ROPE} is provided, the function evaluates the Bayes factor for an interval
null hypothesis. For a point-null hypothesis, \code{ROPE} should be left as \code{NULL}.

\strong{Plotting:}

If \code{plot_power = TRUE}, the function plots the probability of compelling
evidence as a function of sample size. If \code{plot_rel = TRUE}, the relationship betwwen the BF and data is plotted.
}
\examples{
BFpower.ttest.OneSample(
 alternative = "two.sided",
 threshold = 3,
 true_rate = 0.8,
 false_rate = 0.05,
 prior_analysis = "t-distribution",
 location = 0,
 scale = 0.707,
 dff = 1
)
}
