% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BF_users_functions.r
\name{BFpower.ttest.TwoSample}
\alias{BFpower.ttest.TwoSample}
\title{Sample Size Determination for the Two-Sample Bayesian t-Test}
\usage{
BFpower.ttest.TwoSample(
  alternative,
  ROPE = NULL,
  threshold,
  true_rate,
  false_rate,
  prior_analysis,
  location,
  scale,
  dff,
  prior_design = NULL,
  location_d,
  scale_d,
  dff_d,
  N1 = NULL,
  N2 = NULL,
  r = NULL,
  type_rate = "positive",
  plot_power = FALSE,
  plot_rel = FALSE
)
}
\arguments{
\item{alternative}{Character. The direction of the alternative hypothesis: two-sided (\code{"two.sided"}),
right-sided (\code{"greater"}), or left-sided (\code{"less"}).}

\item{ROPE}{Optional numeric. Bounds for an interval null:
\itemize{
\item For \code{hypothesis = "two.sided"}, must be a numeric vector of length 2 with distinct finite values.
\item For \code{"greater"}, must be a single numeric scalar > 0.
\item For \code{"less"}, must be a single numeric scalar < 0.
}}

\item{threshold}{Numeric scalar. Threshold for compelling evidence (must be > 1).}

\item{true_rate}{Numeric scalar. Target true positive or negative rate .}

\item{false_rate}{Numeric scalar. Target false positive or negative rate .}

\item{prior_analysis}{Character. Analysis prior under the alternative hypothesis:
\code{"Normal"}, \code{"Moment"}, or \code{"t-distribution"}.}

\item{location}{Numeric scalar. Location parameter for the analysis prior.}

\item{scale}{Numeric scalar > 0. Scale parameter for the analysis prior.}

\item{dff}{Numeric scalar. Degrees of freedom for the analysis prior (required if prior_analysis = \code{"t-distribution"}; ignored otherwise).}

\item{prior_design}{Optional character. Design prior under the alternative:
\code{"Normal"}, \code{"Moment"}, \code{"t-distribution"}, or \code{"Point"}.}

\item{location_d}{Numeric scalar. Location parameter for the design prior.}

\item{scale_d}{Numeric scalar > 0. Scale parameter for the design prior.}

\item{dff_d}{Numeric scalar. Degrees of freedom for the design prior (required if \code{prior_design = "t-distribution"}; ignored otherwise).}

\item{N1}{Numeric integer. Sample size for group 1 (used if \code{r = NULL}).}

\item{N2}{Numeric integer. Sample size for group 2 (used if \code{r = NULL}).}

\item{r}{Optional numeric scalar. Ratio of sample size \code{N2 / N1} (used if \code{N1} and \code{N2} are NULL).}

\item{type_rate}{Character, either \code{"positive"} or \code{"negative"}; determines whether to control
true/false positive or true/false negative rates .}

\item{plot_power}{Logical. If \code{TRUE}, a plot of the power or probability of compelling evidence is generated.}

\item{plot_rel}{Logical. Whether the relationship between the BF and data is plotted..}
}
\value{
An object of class \code{BFpower_t} containing:
\describe{
\item{type}{Character string describing the test type.}
\item{alternative}{alternative hypothesis (\code{"two.sided"}, \code{"greater"}, or \code{"less"}).}
\item{ROPE}{Interval bounds under the null used, if any.}
\item{analysis_h1}{List with the analysis prior parameters: \code{prior_analysis}, \code{location}, \code{scale}, and optionally \code{dff}.}
\item{design_h1}{List with the design prior parameters: \code{prior_design}, \code{location}, \code{scale}, and optionally \code{dff} (or \code{NULL} if not provided).}
\item{results}{Data frame with probabilities of compelling/misleading evidence.}
\item{threshold}{Threshold of compelling evidence.}
\item{plot_power}{Logical flag for plotting power.}
\item{plot_rel}{Logical flag for plotting the relationship between BF and t-value.}
}
}
\description{
Perform sample size determination or calculate the probabilities of obtaining
compelling or misleading evidence for a two-sample Bayesian t-test.
Supports point-null and interval-null hypotheses, and allows specifying
analysis and design priors.
}
\details{
\strong{1. Sample size determination mode (when \code{N1 = NULL} and \code{N2 = NULL}, but \code{r} is provided):}

If no sample sizes are provided, the function calculates the minimum required sample sizes for both groups. In this mode, the user
must supply:
\itemize{
\item \code{type_rate} - either \code{"positive"} to control true/false positive rates,
or \code{"negative"} to control true/false negative rates.
\item \code{true_rate} - the targeted true positive or true negative rate (between 0.6 and 0.999).
\item \code{false_rate} - the acceptable false positive or false negative rate (between 0.001 and 0.1).
\item \code{threshold} - the Bayes factor threshold for compelling evidence (must be > 1).
\item \code{r} - the allocation ratio of group 2 to group 1 sample sizes (\code{N2/N1}).
}

The function iteratively finds the smallest sample sizes \code{N1} and \code{N2 = r * N1} for which the probability
of obtaining compelling evidence meets or exceeds \code{true_rate}, while the probability of misleading evidence
does not exceed \code{false_rate}.

\strong{2. Fixed-sample analysis mode (when \code{N1} and \code{N2} are supplied):}

If positive numeric sample sizes \code{N1} and \code{N2} are provided, the function computes
the probabilities of obtaining compelling or misleading evidence for those fixed sample sizes. In this mode,
the arguments \code{type_rate}, \code{true_rate}, and \code{false_rate} are ignored; only the Bayes factor threshold \code{threshold} is used.

\strong{Analysis Priors:}

The analysis prior specifies the prior distribution of the effect under the alternative hypothesis. The user must provide:
\itemize{
\item \code{prior_analysis} - the type of prior: \code{"Normal"}, \code{"Moment"} (normal-moment prior), or \code{"t-distribution"}.
\item \code{location} - the mean or location of the prior.
\item \code{scale} - the standard deviation or scale (must be positive).
\item \code{dff} - degrees of freedom (required if \code{prior_analysis = "t-distribution"}).
}

\strong{Design Priors (optional):}

A design prior can be supplied to reflect uncertainty about the effect size during study planning. If provided, the following must be supplied:
\itemize{
\item \code{prior_design} - the type of design prior: \code{"Normal"}, \code{"Moment"}, \code{"t-distribution"}, or \code{"Point"}.
\item \code{location_d} - the location of the design prior.
\item \code{scale_d} - the scale parameter (positive for all models except \code{"Point"}).
\item \code{dff_d} - degrees of freedom for \code{"t-distribution"} design priors.
}

\strong{interval null Hypothesis:}

The argument \code{ROPE} specifies the bounds of an interval null hypothesis.
If \code{ROPE} is provided, the function evaluates the Bayes factor for an interval
null hypothesis. For a point-null hypothesis, \code{ROPE} should be left as \code{NULL}.

\strong{Plotting:}

If \code{plot_power = TRUE}, the function plots the probability of compelling
evidence as a function of the sample sizes. If \code{plot_rel = TRUE}, the relationship between BF and data is plotted.
}
\examples{
BFpower.ttest.TwoSample(
 alternative = "two.sided",
 ROPE = c(-0.36, 0.36),
 threshold = 3,
 true_rate = 0.8,
 false_rate = 0.05,
 prior_analysis = "Normal",
 location = -0.23,
 scale = 0.2,
 dff = 1,
 type_rate = "negative",
 r = 1)
}
