% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{checkKband}
\alias{checkKband}
\title{Check K-band limited property of signals}
\usage{
checkKband(
  SG,
  signals = NULL,
  alpha = 0.05,
  verbose = TRUE,
  k = 25,
  laplacian_type = "normalized"
)
}
\arguments{
\item{SG}{SGWT object with Data slot (from initSGWT)}

\item{signals}{Character vector of signal names to analyze. If NULL, uses all signals from SG$Data$signals}

\item{alpha}{Significance level for Wilcoxon test (default: 0.05)}

\item{verbose}{Logical; if TRUE, print progress messages (default: TRUE)}

\item{k}{Number of nearest neighbors for graph construction (default: 25)}

\item{laplacian_type}{Type of Laplacian ("unnormalized", "normalized", or "randomwalk") (default: "normalized")}
}
\value{
List containing:
  \describe{
    \item{is_kband_limited}{Logical; TRUE if all signals are k-band limited}
    \item{knee_point_low}{Integer; knee point index for low-frequency eigenvalues}
    \item{knee_point_high}{Integer; knee point index for high-frequency eigenvalues}
    \item{signal_results}{List with per-signal test results including p-values and Fourier coefficients}
  }
}
\description{
Analyze whether signals are k-band limited by comparing low-frequency 
and high-frequency Fourier coefficients using eigendecomposition and statistical testing.
Builds graph and computes Laplacian directly from SGWT data.
}
\examples{
\donttest{
# Create example data
data <- data.frame(x = runif(100), y = runif(100),
                  signal1 = rnorm(100), signal2 = rnorm(100))

# Initialize SGWT object (no need to run runSpecGraph)
SG <- initSGWT(data, signals = c("signal1", "signal2"))

# Check k-band limited property
result <- checkKband(SG, signals = c("signal1", "signal2"), k = 30)
if (result$is_kband_limited) {
  cat("All signals are k-band limited")
}
}
}
