% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_checkerboard}
\alias{visualize_checkerboard}
\title{Visualize checkerboard pattern}
\usage{
visualize_checkerboard(df, color1 = "black", color2 = "white")
}
\arguments{
\item{df}{Data frame with X, Y coordinates and signal_1, signal_2 columns}

\item{color1}{Color for signal_1 tiles (default: "black")}

\item{color2}{Color for signal_2 tiles (default: "white")}
}
\value{
ggplot object showing the checkerboard pattern
}
\description{
Create a visualization of checkerboard pattern data
}
\examples{
\donttest{
df <- simulate_checkerboard(grid_size = 6, tile_size = 5)
p <- visualize_checkerboard(df, color1 = "darkblue", color2 = "lightgray")
print(p)
}
}
