% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seeds.R
\docType{data}
\name{seeds}
\alias{seeds}
\title{Seed Germination Data from Crowder (1978)}
\format{
A data frame with 21 observations on the following 4 variables.
\describe{
\item{r}{the number of germinated seeds.}
\item{n}{the total number of seeds.}
\item{seed}{the seed
variety.}
\item{extract}{the type of root extract.} }
}
\source{
Crowder, M. (1978) Beta-Binomial ANOVA for proportions.
\emph{Applied Statistics}, \strong{27}, 34--37.
}
\usage{
seeds
}
\description{
Data from Crowder(1978) giving the proportion of seeds germinated for 21
plates that were arranged according to a 2x2 factorial layout by seed
variety and type of root extract.
}
\examples{

summary(glmmPQL(cbind(r, n - r) ~ seed + extract,
                random = diag(nrow(seeds)),
                family = binomial, 
                data = seeds))

}
\references{
Breslow, N. E. and Clayton, D. G. (1993) Approximate inference
in Generalized Linear Mixed Models. \emph{Journal of the American
Statistical Association}, \strong{88}(421), 9--25.
}
\seealso{
\code{\link[=glmmPQL]{glmmPQL()}}
}
\keyword{datasets}
