% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atom-bu-db.R
\encoding{UTF-8}
\name{catr_atom_get_buildings_db_all}
\alias{catr_atom_get_buildings_db_all}
\alias{catr_atom_get_buildings_db_to}
\title{ATOM INSPIRE: Reference database for ATOM buildings}
\source{
\url{https://www.catastro.hacienda.gob.es/INSPIRE/buildings/ES.SDGC.BU.atom.xml}
}
\usage{
catr_atom_get_buildings_db_all(
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)

catr_atom_get_buildings_db_to(
  to,
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{cache} is no longer
supported; this function will always cache results.}

\item{update_cache}{logical. Should the cached file be refreshed? Default is
\code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{A path to a cache directory. On \code{NULL} the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{to}{character. Territorial office. Internally uses \code{\link[base:grep]{base::grep()}} for
matching.}
}
\value{
A \link[tibble:tbl_df-class]{tibble} with the information requested with the following
fields:
\itemize{
\item \code{territorial_office}: territorial office, corresponding to each province
of Spain except the Basque Country and Navarre.
\item \code{url}: ATOM URL for the corresponding territorial office.
\item \code{munic}: Name of the municipality.
\item \code{date}: Reference date of the data. Note that \strong{the information from this
service is updated twice a year}.
}
}
\description{
Create a database containing the URLs provided in the INSPIRE ATOM service
of the Spanish Cadastre for extracting buildings.
\itemize{
\item \code{catr_atom_get_buildings_db_all()} provides a top-level table including
information on all the territorial offices (except the Basque Country and
Navarre) listing the municipalities included in each office.
\item \code{catr_atom_get_buildings_db_to()} provides a table for the specified
territorial office including information for each of the municipalities
of that office.
}
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
catr_atom_get_buildings_db_all()
}
\dontshow{\}) # examplesIf}
}
\seealso{
INSPIRE API functions:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()},
\code{\link{inspire_wfs_get}()}

Other INSPIRE ATOM services:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_search_munic}()}

Other buildings: 
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_wfs_get_buildings_bbox}()}

Other databases: 
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_search_munic}()},
\code{\link{catr_srs_values}}
}
\concept{ATOM}
\concept{INSPIRE}
\concept{buildings}
\concept{databases}
