% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurvTypes.R
\name{ColossusCoxSurv}
\alias{ColossusCoxSurv}
\title{Interprets basic cox survival formula RHS}
\usage{
ColossusCoxSurv(...)
}
\arguments{
\item{...}{entries for a cox survival object, tstart, tend, and event. Either in order or named. If unnamed and two entries, tend and event are assumed.}
}
\value{
returns list with interval endpoints and event
}
\description{
\code{ColossusCoxSurv} assigns and interprets interval columns for cox model.
This functions is called using the arguments for Cox in the right-hand side of
the formula. Uses an interval start time, end time, and event status. These are
expected to be in order or named: tstart, tend, and event.
The Fine-Gray and Stratified versions use strata and weight named options
or the last two entries.
}
\seealso{
Other Formula Interpretation: 
\code{\link{ColossusLogitSurv}()},
\code{\link{ColossusPoisSurv}()},
\code{\link{get_form}()},
\code{\link{get_form_joint}()}
}
\concept{Formula Interpretation}
