% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasicRun.R
\name{Residual.poisres}
\alias{Residual.poisres}
\title{Calculates the Residuals for a completed poisson model}
\usage{
\method{Residual}{poisres}(
  x,
  df,
  control = list(),
  a_n = c(),
  pearson = FALSE,
  deviance = FALSE,
  ...
)
}
\arguments{
\item{x}{result object from a regression, class poisres}

\item{df}{a data.table containing the columns of interest}

\item{control}{list of parameters controlling the convergence, see the Control_Options vignette for details}

\item{a_n}{list of initial parameter values, used to determine the number of parameters. May be either a list of vectors or a single vector.}

\item{pearson}{boolean to calculate pearson residuals}

\item{deviance}{boolean to calculate deviance residuals}

\item{...}{can include the named entries for the assign_control list parameter}
}
\value{
returns a list of the final results
}
\description{
\code{Residual.poisres} uses user provided data, person-year/event columns, vectors specifying the model,
and options to calculate residuals for a solved Poisson regression
}
\seealso{
Other Poisson Wrapper Functions: 
\code{\link{EventAssignment.poisres}()},
\code{\link{EventAssignment.poisresbound}()},
\code{\link{LikelihoodBound.poisres}()},
\code{\link{PoisRun}()},
\code{\link{PoisRunJoint}()},
\code{\link{PoisRunMulti}()}
}
\concept{Poisson Wrapper Functions}
