% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_download_native.R
\name{cms_download_native}
\alias{cms_download_native}
\alias{cms_list_native_files}
\title{Download raw files as provided to Copernicus Marine}
\usage{
cms_download_native(
  destination,
  product,
  layer,
  pattern,
  prefix,
  progress = TRUE,
  ...,
  username = cms_get_username(),
  password = cms_get_password()
)

cms_list_native_files(product, layer, pattern, prefix, max = Inf, ...)
}
\arguments{
\item{destination}{Path where to store the downloaded file(s).}

\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{cms_product_services}} (listed as \code{id} column).}

\item{pattern}{A regular expression (\href{https://en.wikipedia.org/wiki/Regular_expression}{regex})
pattern. Only paths that match the pattern will be returned. It can be used
to select specific files. For instance if \code{pattern = "2022/06/"}, only files for the
year 2022 and the month June will be listed (assuming that the file path is structured as such, see
examples)}

\item{prefix}{A \code{character} string. A prefix to be added to the search path of the files.
Only the matching file (info) is downloaded (generally faster then using \code{pattern})}

\item{progress}{A \code{logical} value. When \code{TRUE} a progress bar is shown.}

\item{...}{Ignored}

\item{username}{Your Copernicus marine user name. Can be provided with
\code{cms_get_username()} (default), or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{cms_get_password()} (default), or as argument here.}

\item{max}{A maximum number of records to be returned.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Full marine data sets can be downloaded using the functions
documented here. Use \code{cms_list_native_files()} to list available files, and
\code{cms_download_native()} to download specific files. Files are usually organised per product,
layer, year, month and day.
}
\examples{
if (interactive()) {
  cms_list_native_files(
    product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer         = "cmems_mod_glo_phy_anfc_0.083deg_PT1H-m",
    prefix        = "2022/06/"
  )

## If you omit the prefix, you may want to limit the
## number of results by setting `max`
  cms_list_native_files(
    product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer         = "cmems_mod_glo_phy_anfc_0.083deg_PT1H-m",
    max           = 10
  )
  
## Prefix can be omitted when not relevant:
  cms_list_native_files(product = "SEALEVEL_GLO_PHY_MDT_008_063")
  
## Use 'pattern' to download a file for a specific day:
  cms_download_native(
    destination   = tempdir(),
    product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer         = "cmems_mod_glo_phy_anfc_0.083deg_PT1H-m",
    prefix        = "2022/06/",
    pattern       = "m_20220630"
  )
}
}
\author{
Pepijn de Vries
}
