% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cms_download_subset.r
\name{cms_download_subset}
\alias{cms_download_subset}
\title{Subset and download a specific marine product from Copernicus}
\usage{
cms_download_subset(
  product,
  layer,
  variable,
  region,
  timerange,
  verticalrange,
  progress = TRUE,
  crop,
  asset,
  ...,
  username = cms_get_username(),
  password = cms_get_password()
)
}
\arguments{
\item{product}{An identifier (type \code{character}) of the desired Copernicus marine product.
Can be obtained with \code{\link{cms_products_list}}.}

\item{layer}{The name of a desired layer within a product (type \code{character}). Can be obtained with \code{\link{cms_product_services}} (listed as \code{id} column).}

\item{variable}{The name of a desired variable in a specific layer of a product (type \code{character}).
Can be obtained with \code{\link{cms_product_details}}.}

\item{region}{Specification of the bounding box as a \code{vector} of \code{numeric}s WGS84 lat and lon coordinates.
Should be in the order of: xmin, ymin, xmax, ymax.}

\item{timerange}{A \code{vector} with two elements (lower and upper value)
for a requested time range. The \code{vector} should be coercible to \code{POSIXct}.}

\item{verticalrange}{A \code{vector} with two elements (minimum and maximum)
numerical values for the depth of the vertical layers (if any). Note that values below the
sea surface needs to be specified as negative values.}

\item{progress}{A logical value. When \code{TRUE} (default) progress is reported to the console.
Otherwise, this function will silently proceed.}

\item{crop}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. This version now
uses the GDAL library to handle the subsetting and downloading of
subsets. The \code{crop} argument is therefore no longer supported.}

\item{asset}{Type of asset to be used when subsetting data. Should be one
of \code{"default"}, \code{"ARCO"}, \code{"static"}, \code{"omi"}, or \code{"downsampled4"}.
When missing, set to \code{NULL} or set to \code{"default"}, it will use the first
asset available for the requested product and layer, in the order as listed
before.}

\item{...}{Ignored (reserved for future features).}

\item{username}{Your Copernicus marine user name. Can be provided with
\code{cms_get_username()} (default), or as argument here.}

\item{password}{Your Copernicus marine password. Can be provided as
\code{cms_get_password()} (default), or as argument here.}
}
\value{
Returns a \code{\link[stars:st_as_stars]{stars::st_as_stars()}} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Subset and download a specific marine product
from Copernicus.
}
\examples{
if (interactive()) {

  mydata <- cms_download_subset(
    product       = "GLOBAL_ANALYSISFORECAST_PHY_001_024",
    layer         = "cmems_mod_glo_phy-cur_anfc_0.083deg_P1D-m",
    variable      = c("uo", "vo"),
    region        = c(-1, 50, 10, 55),
    timerange     = c("2025-01-01 UTC", "2025-01-02 UTC"),
    verticalrange = c(0, -2)
  )

  plot(mydata["vo"])
} else {
  message("Make sure to run this in an interactive environment")
}
}
\author{
Pepijn de Vries
}
