% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/api.R
\name{DDESONN_activation_defaults}
\alias{DDESONN_activation_defaults}
\alias{ddesonn_activation_defaults}
\title{Legacy alias for \code{\link[=ddesonn_activation_defaults]{ddesonn_activation_defaults()}}}
\usage{
DDESONN_activation_defaults(...)

ddesonn_activation_defaults(
  mode = c("binary", "multiclass", "regression"),
  hidden_sizes = NULL,
  stage = c("train", "predict")
)
}
\arguments{
\item{...}{Additional arguments passed through to
\code{\link[=ddesonn_activation_defaults]{ddesonn_activation_defaults()}}.}

\item{mode}{Problem mode. One of \code{"binary"}, \code{"multiclass"}, or \code{"regression"}.}

\item{hidden_sizes}{Integer vector describing the hidden layer widths.}

\item{stage}{Stage for which activations are required. Either \code{"train"} or \code{"predict"}.}
}
\value{
Same as \code{\link[=ddesonn_activation_defaults]{ddesonn_activation_defaults()}}.

A list of activation functions suitable for passing into the
underlying R6 classes.
}
\description{
Compute sensible activation functions for hidden and output
layers based on the modelling mode and stage (training or prediction).
}
\examples{
ddesonn_activation_defaults("binary", hidden_sizes = c(32, 16))
ddesonn_activation_defaults("regression", hidden_sizes = 64, stage = "predict")

}
