% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activation_functions.R
\name{ddesonn_activation_derivatives}
\alias{ddesonn_activation_derivatives}
\alias{binary_activation_derivative}
\alias{custom_binary_activation_derivative}
\alias{custom_activation_derivative}
\alias{bent_identity_derivative}
\alias{relu_derivative}
\alias{softplus_derivative}
\alias{leaky_relu_derivative}
\alias{elu_derivative}
\alias{tanh_derivative}
\alias{sigmoid_derivative}
\alias{hard_sigmoid_derivative}
\alias{swish_derivative}
\alias{sigmoid_binary_derivative}
\alias{gelu_derivative}
\alias{selu_derivative}
\alias{mish_derivative}
\alias{maxout_derivative}
\alias{prelu_derivative}
\alias{softmax_derivative}
\alias{bent_relu_derivative}
\alias{bent_sigmoid_derivative}
\alias{arctangent_derivative}
\alias{sinusoid_derivative}
\alias{gaussian_derivative}
\alias{isrlu_derivative}
\alias{bent_swish_derivative}
\alias{parametric_bent_relu_derivative}
\alias{leaky_bent_derivative}
\alias{inverse_linear_unit_derivative}
\alias{tanh_relu_hybrid_derivative}
\alias{custom_bent_piecewise_derivative}
\alias{sigmoid_sharp_derivative}
\alias{leaky_selu_derivative}
\alias{identity_derivative}
\title{Activation derivatives (DDESONN)}
\usage{
binary_activation_derivative(x)

custom_binary_activation_derivative(x, threshold = -1.08)

custom_activation_derivative(z)

bent_identity_derivative(x)

relu_derivative(x)

softplus_derivative(x)

leaky_relu_derivative(x, alpha = 0.01)

elu_derivative(x, alpha = 1)

tanh_derivative(x)

sigmoid_derivative(x)

hard_sigmoid_derivative(x)

swish_derivative(x)

sigmoid_binary_derivative(x)

gelu_derivative(x)

selu_derivative(x, lambda = 1.0507, alpha = 1.67326)

mish_derivative(x)

maxout_derivative(x, w1 = 0.5, b1 = 1, w2 = -0.5, b2 = 0.5)

prelu_derivative(x, alpha = 0.01)

softmax_derivative(x)

bent_relu_derivative(x)

bent_sigmoid_derivative(x)

arctangent_derivative(x)

sinusoid_derivative(x)

gaussian_derivative(x)

isrlu_derivative(x, alpha = 1)

bent_swish_derivative(x)

parametric_bent_relu_derivative(x, beta = 1)

leaky_bent_derivative(x, alpha = 0.01)

inverse_linear_unit_derivative(x)

tanh_relu_hybrid_derivative(x)

custom_bent_piecewise_derivative(x, threshold = 0.5)

sigmoid_sharp_derivative(x, temp = 5)

leaky_selu_derivative(x, alpha = 0.01, lambda = 1.0507)

identity_derivative(x)
}
\arguments{
\item{x}{Numeric vector/matrix.}

\item{threshold}{Threshold.}

\item{z}{Numeric vector/matrix.}

\item{alpha}{Leak factor.}

\item{lambda}{SELU lambda.}

\item{w1}{Weight 1.}

\item{b1}{Bias 1.}

\item{w2}{Weight 2.}

\item{b2}{Bias 2.}

\item{beta}{Beta parameter.}

\item{temp}{Temperature/sharpness.}
}
\value{
Vector of zeros.

Vector of zeros.

Zero array with same dims.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Vector of zeros.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Gradient of active affine branch.

Derivative matrix.

Derivative matrix (approx).

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix.

Derivative matrix/vector.

Matrix of ones with same dimensions as \code{x}.
}
\description{
A collection of derivative functions corresponding to DDESONN activation functions.
}
