% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activation_functions.R
\name{ddesonn_activations}
\alias{ddesonn_activations}
\alias{binary_activation}
\alias{custom_binary_activation}
\alias{custom_activation}
\alias{bent_identity}
\alias{relu}
\alias{softplus}
\alias{leaky_relu}
\alias{elu}
\alias{tanh}
\alias{sigmoid}
\alias{hard_sigmoid}
\alias{swish}
\alias{sigmoid_binary}
\alias{gelu}
\alias{selu}
\alias{mish}
\alias{prelu}
\alias{softmax}
\alias{maxout}
\alias{bent_relu}
\alias{bent_sigmoid}
\alias{arctangent}
\alias{sinusoid}
\alias{gaussian}
\alias{isrlu}
\alias{bent_swish}
\alias{parametric_bent_relu}
\alias{leaky_bent}
\alias{inverse_linear_unit}
\alias{tanh_relu_hybrid}
\alias{custom_bent_piecewise}
\alias{sigmoid_sharp}
\alias{leaky_selu}
\alias{identity}
\title{Activation functions (DDESONN)}
\usage{
binary_activation(x)

custom_binary_activation(x, threshold = -1.08)

custom_activation(z)

bent_identity(x)

relu(x)

softplus(x)

leaky_relu(x, alpha = 0.01)

elu(x, alpha = 1)

tanh(x)

sigmoid(x)

hard_sigmoid(x)

swish(x)

sigmoid_binary(x)

gelu(x)

selu(x, lambda = 1.0507, alpha = 1.67326)

mish(x)

prelu(x, alpha = 0.01)

softmax(z)

maxout(x, w1 = 0.5, b1 = 1, w2 = -0.5, b2 = 0.5)

bent_relu(x)

bent_sigmoid(x)

arctangent(x)

sinusoid(x)

gaussian(x)

isrlu(x, alpha = 1)

bent_swish(x)

parametric_bent_relu(x, beta = 1)

leaky_bent(x, alpha = 0.01)

inverse_linear_unit(x)

tanh_relu_hybrid(x)

custom_bent_piecewise(x, threshold = 0.5)

sigmoid_sharp(x, temp = 5)

leaky_selu(x, alpha = 0.01, lambda = 1.0507)

identity(x)
}
\arguments{
\item{x}{Numeric vector/matrix.}

\item{threshold}{Threshold for piecewise.}

\item{z}{Numeric vector/matrix.}

\item{alpha}{Leak factor.}

\item{lambda}{SELU lambda.}

\item{w1}{Weight 1.}

\item{b1}{Bias 1.}

\item{w2}{Weight 2.}

\item{b2}{Bias 2.}

\item{beta}{Beta parameter.}

\item{temp}{Temperature/sharpness.}
}
\value{
A matrix of 0/1 values with the same dimensions as \code{x}.

A matrix of 0/1 values with the same dimensions as \code{x}.

A matrix of 0/1 values with the same dimensions as \code{z}.

Bent identity transform.

ReLU transform.

Softplus transform.

Leaky ReLU transform.

ELU transform.

tanh transform.

Sigmoid transform.

Hard sigmoid transform.

Swish transform.

0/1 matrix.

GELU transform.

SELU transform.

Mish transform.

PReLU transform.

Row-wise softmax probabilities.

Elementwise max of two affine transforms.

Bent ReLU transform.

Bent sigmoid transform.

atan transform.

sin transform.

exp(-x^2).

ISRLU transform.

Bent swish transform.

Parametric bent ReLU transform.

Leaky bent transform.

x/(1+abs(x)).

Hybrid transform.

Piecewise transform.

Sharpened sigmoid.

Leaky SELU transform.

Base identity function.
}
\description{
A collection of activation functions used by DDESONN.
These functions operate on numeric vectors/matrices and preserve shape.
}
\details{
Many functions coerce inputs to matrix form and preserve dimensions.
Some functions are experimental and may not be suitable for training.
}
