% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R, R/api.R
\name{DDESONN_model}
\alias{DDESONN_model}
\alias{ddesonn_model}
\title{Legacy alias for \code{\link[=ddesonn_model]{ddesonn_model()}}}
\usage{
DDESONN_model(...)

ddesonn_model(
  input_size,
  output_size,
  hidden_sizes = c(64, 32),
  num_networks = 1L,
  lambda = 0.00028,
  classification_mode = c("binary", "multiclass", "regression"),
  ML_NN = TRUE,
  activation_functions = NULL,
  activation_functions_predict = NULL,
  init_method = "he",
  custom_scale = 1,
  N = NULL,
  ensembles = NULL,
  ensemble_number = 0L,
  verbose = FALSE,
  verboseLow = FALSE,
  debug = FALSE
)
}
\arguments{
\item{...}{Additional arguments passed through to
\code{\link[=ddesonn_model]{ddesonn_model()}}.}

\item{input_size}{Number of input features.}

\item{output_size}{Number of outputs.}

\item{hidden_sizes}{Integer vector describing hidden layer widths.}

\item{num_networks}{Number of SONN members to initialise within the ensemble.}

\item{lambda}{Regularisation strength.}

\item{classification_mode}{Problem mode: \code{"binary"}, \code{"multiclass"}, or \code{"regression"}.}

\item{ML_NN}{Logical; whether to initialise a multi-layer SONN.}

\item{activation_functions}{Optional list of activation functions for training.}

\item{activation_functions_predict}{Optional list of activation functions used during prediction.}

\item{init_method}{Weight initialisation scheme passed to the legacy constructor.}

\item{custom_scale}{Optional scaling factor for the initialiser.}

\item{N}{Optional total node count. If omitted it is inferred from the architecture.}

\item{ensembles}{Optional pre-existing ensemble container.}

\item{ensemble_number}{Identifier used when combining multiple ensembles.}

\item{verbose}{Logical; emit detailed progress output when TRUE.}

\item{verboseLow}{Logical; emit important progress output when TRUE.}

\item{debug}{Logical; emit debug diagnostics when TRUE.}
}
\value{
Same as \code{\link[=ddesonn_model]{ddesonn_model()}}.

A \code{ddesonn_model} (R6) instance ready for training.
}
\description{
Initialise a \code{ddesonn_model} (R6) instance backed by the legacy
\code{DDESONN} class, while handling sensible defaults for activations and node
counts.
}
\examples{
model <- ddesonn_model(
  input_size = 5,
  output_size = 1,
  hidden_sizes = c(32, 16),
  classification_mode = "binary"
)

}
\seealso{
\link{DDESONN-package}
}
