% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ddesonn_model}
\alias{predict.ddesonn_model}
\title{Predict method for DDESONN models}
\usage{
\method{predict}{ddesonn_model}(
  object,
  newdata,
  ...,
  aggregate = c("mean", "median", "none"),
  type = c("response", "class"),
  threshold = NULL,
  verbose = FALSE,
  verboseLow = FALSE,
  debug = FALSE
)
}
\arguments{
\item{object}{A ddesonn_model (R6) returned by ddesonn_run() / ddesonn_model().}

\item{newdata}{Matrix/data.frame of predictors.}

\item{...}{Unused.}

\item{aggregate}{Aggregation strategy across ensemble members.}

\item{type}{Prediction type. \code{"response"} returns numeric predictions,
while \code{"class"} returns class labels for classification problems.}

\item{threshold}{Optional threshold override when \code{type = "class"}.}

\item{verbose}{Logical; emit detailed progress output when TRUE.}

\item{verboseLow}{Logical; emit important progress output when TRUE.}

\item{debug}{Logical; emit debug diagnostics when TRUE.}
}
\description{
This is the canonical user-facing wrapper around \code{\link[=ddesonn_predict]{ddesonn_predict()}}. It
standardizes arguments (\code{type}, \code{aggregate}, \code{threshold}) and normalizes the
output structure for inference workflows.
Multiclass note: For multiclass classification, y should be encoded as integer class indices 1..K (or a one-hot matrix whose columns follow the model’s class order), otherwise accuracy comparisons may be incorrect.
}
