% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{Fdem}
\alias{Fdem}
\alias{Fdem_CC}
\alias{Fdem_ML}
\title{Demographic FMSY method}
\usage{
Fdem(x, Data, reps = 100, plot = FALSE)

Fdem_CC(x, Data, reps = 100, plot = FALSE, Fmin = 0.005)

Fdem_ML(x, Data, reps = 100, plot = FALSE, Fmin = 0.005)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{Fmin}{The minimum fishing mortality rate derived from the catch-curve
analysis}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
FMSY is calculated as r/2 where r is calculated from a demographic approach
(inc steepness). Coupled with an estimate of current abundance that gives
you the OFL.
}
\details{
The TAC is calculated as:
\deqn{\textrm{TAC} = F_{\textrm{MSY}} A}
where \emph{A} is an estimate of current abundance, and \eqn{F_{\textrm{MSY}}} is estimated
as \eqn{r/2}, where \eqn{r} is the intrinsic rate of population growth, estimated
from the life-history parameters using the methods of McAllister et al. (2001).
}
\section{Functions}{
\itemize{
\item \code{Fdem()}: Current abundance is assumed to be known (i.e \code{Data@Abun})

\item \code{Fdem_CC()}: Current abundance is estimated from catch curve analysis

\item \code{Fdem_ML()}: Current abundance is estimated from mean length

}}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{Fdem}: Abun, FMSY_M, L50, MaxAge, Mort, steep, vbK, vbLinf, vbt0, wla, wlb


\code{Fdem_CC}: CAA, Cat, FMSY_M, L50, MaxAge, Mort, steep, vbK, vbLinf, vbt0, wla, wlb


\code{Fdem_ML}: CAL, Cat, FMSY_M, L50, Lbar, Lc, MaxAge, Mort, steep, vbK, vbLinf, vbt0, wla, wlb
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/Fdem.html}{Online Documentation} for correctly rendered equations




}

\examples{
Fdem(1, MSEtool::SimulatedData, plot=TRUE)
Fdem_CC(1, MSEtool::SimulatedData, plot=TRUE)
Fdem_ML(1, MSEtool::SimulatedData, plot=TRUE)
}
\references{
McAllister, M.K., Pikitch, E.K., and Babcock, E.A. 2001. Using
demographic methods to construct Bayesian priors for the intrinsic rate of
increase in the Schaefer model and implications for stock rebuilding. Can.
J. Fish. Aquat. Sci. 58: 1871-1890.
}
\author{
T. Carruthers
}
